// diffuse.vs
//
// Standardowe przeksztacenie wierzchokw,
// wiato rozproszone wyliczone na podstawie
// pojedynczego rda wiata biaego

uniform vec3 lightPos0;

void main(void)
{
    // przeksztacenia model-widok
    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

    vec3 N = normalize(gl_NormalMatrix * gl_Normal);
    vec4 V = gl_ModelViewMatrix * gl_Vertex;
    vec3 L = normalize(lightPos0 - V.xyz);

    // zwrcenie koloru wierzchoka owietlonego wiatem rozproszonym
    float NdotL = dot(N, L);
    gl_FrontColor = gl_Color * vec4(max(0.0, NdotL));
}

